:connect  @PR_REPLICA@
USE master
GO

--Check if the AG group exists
DECLARE @mainIsPrimary INT
DECLARE @mirrorIsPrimary INT

SELECT @mainIsPrimary = [master].sys.fn_hadr_backup_is_preferred_replica(database_name)
FROM [master].sys.availability_databases_cluster dbs 
	JOIN [master].sys.availability_groups ag ON ag.group_id = dbs.group_id AND ag.name = '@AG_NAME@' 
WHERE dbs.database_name = '@UT_DB_NAME@' 

IF @@ROWCOUNT = 1
BEGIN
	IF @mainIsPrimary = 1
			ALTER AVAILABILITY GROUP [@AG_NAME@] REMOVE DATABASE [@UT_DB_NAME@];
	ELSE
		THROW 60000, N'@UT_DB_NAME@ IS NOT ON the Primary Replica - Check @AG_NAME@ state',1
END

SELECT @mirrorIsPrimary = [master].sys.fn_hadr_backup_is_preferred_replica(database_name)
FROM [master].sys.availability_databases_cluster dbs 
	JOIN [master].sys.availability_groups ag ON ag.group_id = dbs.group_id AND ag.name = '@AG_NAME@' 
WHERE dbs.database_name = '@UT_DB_NAME@_MIRROR' 

IF @@ROWCOUNT = 1
BEGIN
	IF @mainIsPrimary = 1
			ALTER AVAILABILITY GROUP [@AG_NAME@] REMOVE DATABASE [@UT_DB_NAME@_MIRROR];
	ELSE
		THROW 60001, N'@UT_DB_NAME@_MIRROR IS NOT ON the Primary Replica - Check @AG_NAME@ state',1
END
GO

WAITFOR DELAY '00:02:00' -- wait for the AG to ripple
GO

--Kill any active connections (if the database isn't primary we'd error out avoe, so only need to do this on primary)
DECLARE @activeDbUsers TABLE ( DbUserID INT IDENTITY(1,1), UserSpid SMALLINT NOT NULL )

INSERT INTO @activeDbUsers( UserSpid )
SELECT spid
FROM master.sys.sysprocesses P
JOIN master.sys.sysdatabases D ON P.dbid = D.dbid
WHERE D.[name] LIKE '@UT_DB_NAME@%' AND spid <> @@SPID

    IF @@ERROR <> 0 
        THROW 60003, N'Error occurred while trying to fetch a list of users to kill', 1

    DECLARE 
        @sql NVARCHAR(4000),
        @userRecordId INT,
        @numberOfUsersToKill INT,
        @errorBuf INT
	
	SELECT @numberOfUsersToKill = COUNT(1) FROM @activeDbUsers
    SET @userRecordId = 1

	WHILE @userRecordId <= @numberOfUsersToKill
	BEGIN
		SELECT @sql = N'KILL ' + CAST( UserSpid AS NVARCHAR(30) ) 
		FROM 
			@activeDbUsers 
		WHERE 
			DbUserID = @userRecordId
		
		IF @@ERROR <> 0 
			THROW 60004, N'Error occurred while trying to prepare dynamic SQL to kill user', 1

		EXEC( @sql )
		
		IF @@ERROR <> 0 
			THROW 60005, N'Error occurred while trying to kill active user with dynamic SQL', 1

		SET @userRecordId = @userRecordId + 1
	END
GO



--DR first
:connect @DR_REPLICA@
IF EXISTS (SELECT 1 FROM [master].sys.sysdatabases WHERE [name] = '@UT_DB_NAME@')
	DROP DATABASE [@UT_DB_NAME@]
IF EXISTS (SELECT 1 FROM [master].sys.sysdatabases WHERE [name] = '@UT_DB_NAME@_MIRROR')
	DROP DATABASE [@UT_DB_NAME@_MIRROR]
GO

--HA second
:connect @HA_REPLICA@
IF EXISTS (SELECT 1 FROM [master].sys.sysdatabases WHERE [name] = '@UT_DB_NAME@')
	DROP DATABASE [@UT_DB_NAME@]
IF EXISTS (SELECT 1 FROM [master].sys.sysdatabases WHERE [name] = '@UT_DB_NAME@_MIRROR')
	DROP DATABASE [@UT_DB_NAME@_MIRROR]
GO

--PR last
:connect @PR_REPLICA@
IF EXISTS (SELECT 1 FROM [master].sys.sysdatabases WHERE [name] = '@UT_DB_NAME@')
	DROP DATABASE [@UT_DB_NAME@]
IF EXISTS (SELECT 1 FROM [master].sys.sysdatabases WHERE [name] = '@UT_DB_NAME@_MIRROR')
	DROP DATABASE [@UT_DB_NAME@_MIRROR]
GO